data{
    int n;
    array[n] int<lower=0> days;
    vector[n] age_g2;
    vector[n] age_g3;
    vector[n] sex_g;
    array[n] int<lower=0> deaths;
}
parameters{
    real beta0;
    vector[5] beta;
}
transformed parameters{
    vector[n] log_lambda;
    {
        for(i in 1:n){
            log_lambda[i] = beta0 + 
                            beta[1]*age_g2[i] +         
                            beta[2]*age_g3[i] +
                            beta[3]*sex_g[i] +
                            beta[4]*age_g2[i]*sex_g[i] +
                            beta[5]*age_g3[i]*sex_g[i];
        }
    }
    vector[n] lambda;
    vector[n] mean_deaths;
    {
        for(i in 1:n){
            lambda[i] = exp(log_lambda[i]);
            mean_deaths[i] = lambda[i] * days[i];
        }
    }
}
model{
    // Likelihood
    for(i in 1:n){
        deaths[i] ~ poisson(mean_deaths[i]);
    }
    // Priors
    beta0 ~ normal(-4.07, 100); //log(13/760)
    for(j in 1:5){
        beta[j] ~ normal(0, 100);
    }
}
generated quantities{
    vector[n] ResDev;
    real ResDevTotal;
    {
        real local_param;
        for(i in 1:n){
            local_param = 2 * ( (mean_deaths[i]- deaths[i]) + deaths[i] * log(deaths[i] / mean_deaths[i]) );
            ResDev[i] = deaths[i]==0 ? 2*mean_deaths[i] : local_param;
        }
        ResDevTotal = sum(ResDev);
    }
    //  log-likelihood
    vector[n] log_likelihood;
  {
    for(i in 1:n){
      log_likelihood[i] = poisson_lpmf(deaths[i] | mean_deaths[i]);
    }
  }
  real log_lik;
  {
    log_lik = sum(log_likelihood);
  }
}